<?php
/**
* @package icarus
* @subpackage form-markup-generator
*/

/**
* require parent file
*/
require_once field_markup_generator_path('tiny_text_area');

/**
* @uses _text_input.php
* @uses _text_input_field.php
* @uses _label.php
*
* @package icarus
* @subpackage form-markup-generator
*/
class Emplids_markup_generator extends Tiny_text_area_markup_generator{
	protected $_type = 'emplids';
	protected $validation_method = 'comma_separated_list_of_emplids'; 
	protected $_feedback_invalid_input = "Please enter a comma-separated list of employee IDs for the %s field.";
	
	function feedback_invalid_input(){
		//if it's not a comma-separated list and it still doesn't work.	
		$invalid_emplids = array();
		$list_items = explode(',', $this->value);
		foreach($list_items as $list_item){
			if(!$this->validator->is_a_string_like_an_emplid($list_item) || !$this->validator->is_an_emplid($list_item))
				$invalid_emplids[] = $this->error->describe($list_item);
		}
		
		$message = "The ".$this->link_to_field()." field should be a comma-separated list of employee IDs";
		if(count($invalid_emplids) == 1)
			$message .= ', but '.first_element($invalid_emplids).' is not a valid ID';
		else
			$message .= ', but '.array_to_human_readable_list($invalid_emplids).' are not valid IDs';
		
		return $message.".";
	}
	
	function set_value($value){
		//be forgiving of whitespace.  people shouldn't have to panic about spaces.
		$value = implode(',', array_unique(array_map('trim', explode(",", $value))));
		parent::set_value($value);
	}
	
}